﻿var surveySessions = {
    context: $(".v-surveySessions"),
    datatable: null,
    refreshDataTable: function () {
        surveySessions.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-surveySessionsTable", surveySessions.context).a4datatable({
            height: "full",
            stateKey: "SurveySessions",
            ajaxAction: a4.getAction("GetSurveySessions", "Diagnostics", "Settings"),
            columns: [
                { "Name": "SessionId", "Title": resources.Id, "Data": "Id", "Class": "id", "Visible": false },
                { "Name": "ClientId", "Title": resources.Client, "Data": "ClientId" },
                { "Name": "SurveyId", "Title": resources.SurveyId, "Data": "SurveyId" },
                { "Name": "ProjectName", "Title": resources.Survey, "Data": "SurveyName" },
                { "Name": "RespondentId", "Title": resources.Respondent, "Data": "RespondentId" },
                { "Name": "CurrentQuestionAlias", "Title": resources.Question, "Data": "CurrentQuestion" },
                { "Name": "IpAddress", "Title": resources.IP, "Data": "IpAddress" },
                { "Name": "Progression", "Title": resources.Progress, "Data": "Progress" },
                { "Name": "Created", "Title": resources.CreatedOn, "Data": "Created", "Type": "date" },
                { "Name": "Expires", "Title": resources.ExpirationDate, "Data": "Expires", "Type": "date" }
            ],
            localizableTexts: { "Search": resources.SearchSurveySessions },
            defaultSorting: "ClientId",
            advancedFilter: true
        });
    },
    bindEvents: function () {
        surveySessions.context.on("click", ".h-exportLogs", function () {
            var tableParams = surveySessions.datatable.a4datatable("getTableParams");
            var link = a4.getAction("ExportSurveySessions", "Diagnostics", "Settings", { tableParams: JSON.stringify(tableParams) });
            a4.showBusyBox();

            a4.callServerMethod(link, {},
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getAction("GetExportSurveySessionsFile", "Diagnostics", "Settings", { filename: result });
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            });
        });
    }
}

$(document).ready(function () {
    if (surveySessions.context.length > 0) {
        surveySessions.initializeDataTable();
        surveySessions.bindEvents();
    }
});


